/********************************************************************************
 		Remote Control State Machine
		Mauro Grassi May 2008 for Musicolour BETA ver 8.0 and above
 		based on code by Peter Smith
		Infrared receive state machine (must be called every 64us)
*********************************************************************************/
#include <p30F4011.h>
#include "ir.h"

int ir_timer, ir_state, ir_bit_cnt, ir_cmd, ir_code, ir_rpt, ir_rdy;
/********************************************************************************
 RC5 State 0
 Wait for line idle (high)
********************************************************************************/
void initRC5(void)
{
	ir_state=0;
	ir_timer=0;
	ir_rdy=0;
	ir_code=0;
	ir_cmd=0;
	ir_rpt=0;
}

void rc5_s0(void)
{
	if(IR_RXD==1){ ir_rdy=0; ir_timer=0; ir_state++; }
}
/********************************************************************************
 RC5 State 1
 Establish line is idle (high) for 5ms before waiting for a start bit
********************************************************************************/
void rc5_s1(void)
{
	if(IR_RXD==0){ ir_state=0; } 
	else if(ir_timer>=78)ir_state++;
}
/********************************************************************************
 RC5 State 2
 Wait (forever) for start bit
********************************************************************************/
void rc5_s2(void)
{
	if(IR_RXD==0){
				ir_timer=0;
				ir_state++;
	}
}
/***************************************************************************
 RC5 State 3
 Wait for rising edge of first start bit
***************************************************************************/
void rc5_s3(void)
{
	if(IR_RXD==1){
			ir_timer=0;
			ir_state++;
	} else	if(ir_timer>=31)ir_state=0;		//  more than 2ms?
}
/***************************************************************************
 RC5 State 4
 Wait for trailing edge of second start bit to synchronise timing
***************************************************************************/
void rc5_s4(void)
{
	if(IR_RXD==0){
		ir_bit_cnt=12;			// initialize bit count (12 bits)
		ir_cmd=0;				// zero the command
		ir_timer=0;				// reset timer
		ir_state++;
 	} else if(ir_timer>=31)ir_state=0;
}
/***************************************************************************
 RC5 State 5
 Sample the line at 1/4 bit time and store result
***************************************************************************/
void rc5_s5(void)
{
	if(ir_timer>=21)
	{
		ir_state++;
		if(IR_RXD==0){
			ir_cmd<<1;
			ir_cmd&=0xFFFE;
			ir_timer=0;
		} else
		{
			ir_cmd<<1;
			ir_cmd|=0x0001;
			ir_timer=0;	
			ir_state++;
		}
	}
}

void ir_is_finished(void)
{
		ir_bit_cnt--;
		if(ir_bit_cnt!=0)
		{
			ir_state=5;
			ir_timer=0;
		} else 
		{
			if(ir_cmd==ir_code)ir_rpt=1; else ir_rpt=0;
			ir_code=ir_cmd;
			ir_rdy=1;
			ir_state=0;
		}	
}
/***************************************************************************
 RC5 State 6
 Bit was a low, so wait for rising edge to syncronize timing
***************************************************************************/
void rc5_s6(void)
{
	if(IR_RXD==1)ir_is_finished();
	else if(ir_timer>=35)ir_state=0;
}
/***************************************************************************
 RC5 State 7
 Bit was a high, so wait for falling edge to syncronize timing
**************************************************************************/
void rc5_s7(void)
{
	if(IR_RXD==0)ir_is_finished();
	else if(ir_timer>=35)ir_state=0;
}

int ir_receive(void)
{
	ir_timer++;
	ir_state&=0x0007;
	switch(ir_state)
	{
		case 0:
			rc5_s0();
			break;
		case 1:
			rc5_s1();
			break;
		case 2:
			rc5_s2();
			break;
		case 3:
			rc5_s3();
			break;
		case 4:
			rc5_s4();
			break;
		case 5:	
			rc5_s5();
			break;
		case 6:
			rc5_s6();
			break;
		case 7:
			rc5_s7();
	}
	return 0;
}

